/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.logon;

import com.ibm.hwmca.base.logon.LogonApp;
import com.ibm.hwmca.base.logon.LogonConstants;
import com.ibm.hwmca.base.logon.LogonErrorIds;
import com.ibm.hwmca.base.logon.NonPanelLogon;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.system.ClientUserContext;
import com.ibm.hwmca.fw.system.CommonSystem;
import com.ibm.hwmca.fw.task.PresentationTaskParms;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.Trace;
import java.net.UnknownHostException;

public class Logon
implements LogonConstants,
LogonErrorIds {
    private static final String TRACE_MASKT = "XLGN   T";
    private static final String TRACE_MASKF = "XLGN   F";
    private static final String TRACE_MASKD = "XLGN   D";
    private static Logon logon;
    private static int logonResult;
    private ClientUserContext clientUserContext;

    private Logon() {
        Trace.trace(TRACE_MASKT, "-> Logon.Logon()");
        try {
            this.clientUserContext = new ClientUserContext(CommonSystem.getCommonSystem().getManagerHost(), 9940);
        }
        catch (UnknownHostException exc) {
            Trace.trace(TRACE_MASKF, exc);
            new FrameworkLog(LogonErrorIds.LOGINFO, 101, exc).log();
        }
        Trace.trace(TRACE_MASKT, "<- Logon.Logon()");
    }

    public static Logon getLogon() {
        if (logon == null) {
            logon = new Logon();
        }
        Trace.trace(TRACE_MASKT, "<> Logon.getLogon()");
        return logon;
    }

    public void logon(String userid, byte[] password) {
        Trace.trace(TRACE_MASKT, "-> Logon.logon()");
        logonResult = 0;
        if (userid != null && password != null) {
            Trace.trace(TRACE_MASKF, "Logon.logon(): trying non-panel logon session");
            NonPanelLogon nonPanelLogon = new NonPanelLogon();
            nonPanelLogon.logon(userid, password);
        }
        if (logonResult == 0) {
            try {
                PresentationTaskParms parms = new PresentationTaskParms(null);
                LogonApp logonApp = new LogonApp(parms);
                while (logonResult == 0) {
                    Trace.trace(TRACE_MASKF, "Logon.logon(): trying panel tasklet logon session");
                    logonApp.execute();
                }
            }
            catch (TaskletException exc) {
                Trace.trace(TRACE_MASKF, exc);
                new FrameworkLog(LogonErrorIds.LOGINFO, 96, exc).log();
            }
        }
        Trace.trace(TRACE_MASKT, "<- Logon.logon()");
    }

    public boolean isLogonSuccessful() {
        Trace.trace(TRACE_MASKT, "<> Logon.isLogonSuccessful()");
        return logonResult == 2;
    }

    public boolean isLogonCanceled() {
        Trace.trace(TRACE_MASKT, "<> Logon.isLogonCanceled()");
        return logonResult == 1;
    }

    void setLogonResult(int result) {
        Trace.trace(TRACE_MASKT, "-> Logon.setLogonResult()");
        logonResult = result;
        Trace.trace(TRACE_MASKT, "<- Logon.setLogonResult()");
    }

    public ClientUserContext getClientUserContext() {
        return this.clientUserContext;
    }
}

